/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.editor.ruby.formatter.internal.nodes;

import com.aptana.formatter.ExcludeRegionList;
import com.aptana.formatter.FormatterUtils;
import com.aptana.formatter.IFormatterCallback;
import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterRawWriter;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.FormatterTextNode;
import org.eclipse.jface.text.IRegion;

public class FormatterHereDocNode
extends FormatterTextNode
implements IFormatterCallback {
    private final boolean indent;
    private IRegion contentRegion;
    private IRegion endMarkerRegion;

    public FormatterHereDocNode(IFormatterDocument document, int startOffset, int endOffset, boolean indent) {
        super(document, startOffset, endOffset);
        this.indent = indent;
    }

    public IRegion getContentRegion() {
        return this.contentRegion;
    }

    public void setContentRegion(IRegion contentRegion) {
        this.contentRegion = contentRegion;
    }

    public IRegion getEndMarkerRegion() {
        return this.endMarkerRegion;
    }

    public void setEndMarkerRegion(IRegion endMarkerRegion) {
        this.endMarkerRegion = endMarkerRegion;
    }

    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        IFormatterContext heredocContext = context.copy();
        heredocContext.setIndenting(false);
        visitor.write(heredocContext, this.getStartOffset(), this.getEndOffset());
        if (this.contentRegion != null) {
            visitor.excludeRegion(this.contentRegion, ExcludeRegionList.EXCLUDE_STRATEGY.WRITE_AS_IS);
        }
        if (this.endMarkerRegion != null) {
            visitor.excludeRegion(this.endMarkerRegion, ExcludeRegionList.EXCLUDE_STRATEGY.WRITE_AS_IS);
        }
        visitor.addNewLineCallback((IFormatterCallback)this);
    }

    public void call(IFormatterContext context, IFormatterRawWriter writer) {
        IFormatterDocument doc = this.getDocument();
        if (this.contentRegion != null && this.contentRegion.getLength() > 0) {
            writer.writeText(context, doc.get(this.contentRegion));
        }
        if (this.endMarkerRegion != null) {
            String endMarker = doc.get(this.endMarkerRegion);
            if (this.indent) {
                writer.writeIndent(context);
                int i = 0;
                while (i < endMarker.length() && FormatterUtils.isSpace((char)endMarker.charAt(i))) {
                    ++i;
                }
                writer.writeText(context, endMarker.substring(i));
            } else {
                writer.writeText(context, endMarker);
            }
        }
    }

    public boolean isIndent() {
        return this.indent;
    }
}

